/*
 * Decompiled with CFR 0.152.
 */
package com.arcaryx.hodtweaks.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.pixelmonmod.pixelmon.api.command.PixelmonCommandUtils;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.pokemon.item.pokeball.PokeBall;
import com.pixelmonmod.pixelmon.api.storage.PlayerPartyStorage;
import com.pixelmonmod.pixelmon.command.PixelCommand;
import com.pixelmonmod.pixelmon.items.PokeBallItem;
import com.pixelmonmod.pixelmon.items.PokeBallPart;
import java.util.List;
import java.util.Optional;
import net.minecraft.command.CommandException;
import net.minecraft.command.CommandSource;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;

public class BallSwapCommand
extends PixelCommand {
    public BallSwapCommand(CommandDispatcher<CommandSource> dispatcher) {
        super(dispatcher, "ballswap", "/ballswap <slot>", 0);
    }

    public void execute(CommandSource sender, String[] args) throws CommandException, CommandSyntaxException {
        if ((args = this.setupTargetOrSourceAsTarget(sender, args, 0)).length < 2) {
            sender.func_197030_a((ITextComponent)PixelmonCommandUtils.format((TextFormatting)TextFormatting.RED, (String)"pixelmon.command.general.invalid", (Object[])new Object[0]), false);
            PixelmonCommandUtils.endCommand((String)this.getUsage(sender), (Object[])new Object[0]);
        }
        ServerPlayerEntity player = PixelmonCommandUtils.requireEntityPlayer((String)args[0]);
        PlayerPartyStorage storage = (PlayerPartyStorage)PixelmonCommandUtils.require((Object)PixelmonCommandUtils.getPlayerStorage((ServerPlayerEntity)player), (String)"pixelmon.command.general.invalidplayer", (Object[])new Object[0]);
        int slot = PixelmonCommandUtils.requireInt((String)args[1], (int)1, (int)6, (String)"pixelmon.command.pokeedit.slot", (Object[])new Object[0]);
        Pokemon pokemon = (Pokemon)PixelmonCommandUtils.require((Object)storage.get(slot - 1), (String)"pixelmon.command.partyslot.nothing", (Object[])new Object[]{player.func_200200_C_()});
        ItemStack selectedItem = player.func_184586_b(Hand.MAIN_HAND);
        Optional pokeBall = PokeBallPart.getPokeBall((ItemStack)selectedItem);
        if (!pokeBall.isPresent() || !(selectedItem.func_77973_b() instanceof PokeBallItem)) {
            PixelmonCommandUtils.endCommand((String)"Invalid Item in hand: Select a Pokeball!", (Object[])new Object[0]);
        }
        String oldBallType = pokemon.getBall().getLocalizedName();
        String newBallType = ((PokeBall)pokeBall.get()).getLocalizedName();
        if (!player.func_184812_l_()) {
            selectedItem.func_190918_g(1);
        }
        pokemon.setBall((PokeBall)pokeBall.get());
        sender.func_197030_a((ITextComponent)PixelmonCommandUtils.format((TextFormatting)TextFormatting.GREEN, (String)"Swapped out %s from a %s to a %s!", (Object[])new Object[]{pokemon.getLocalizedName(), oldBallType, newBallType}), false);
    }

    public List<String> getTabCompletions(MinecraftServer server, CommandSource sender, String[] args, BlockPos pos) throws CommandSyntaxException {
        switch (args.length) {
            case 0: {
                return super.getTabCompletions(server, sender, args, pos);
            }
            case 1: {
                return PixelmonCommandUtils.PARTY_SLOTS;
            }
        }
        return null;
    }
}

