/*
 * Decompiled with CFR 0.152.
 */
package com.arcaryx.hodtweaks.mixin.opf;

import com.anar4732.opf.client.DownloadingTextureExtended;
import com.arcaryx.hodtweaks.HoDTweaks;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.NativeImage;
import net.minecraft.client.renderer.texture.SimpleTexture;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import org.apache.commons.io.FileUtils;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={DownloadingTextureExtended.class})
public abstract class MixinDownloadingTextureExtended
extends SimpleTexture {
    @Shadow
    private CompletableFuture<?> future;
    @Final
    @Shadow
    private File cacheFile;
    @Shadow
    public boolean error;
    @Final
    @Shadow
    private String imageUrl;

    public MixinDownloadingTextureExtended(ResourceLocation pLocation) {
        super(pLocation);
    }

    @Inject(at={@At(value="HEAD")}, method={"load(Lnet/minecraft/resources/IResourceManager;)V"}, cancellable=true, require=1)
    private void fixLoad(IResourceManager manager, CallbackInfo ci) throws IOException {
        if (this.future == null) {
            NativeImage nativeimage;
            if (this.cacheFile != null && this.cacheFile.isFile()) {
                HoDTweaks.LOGGER.debug("Loading http texture from local cache ({})", (Object)this.cacheFile);
                FileInputStream fileinputstream = new FileInputStream(this.cacheFile);
                nativeimage = this.loadTexture(fileinputstream);
            } else {
                nativeimage = null;
            }
            if (nativeimage != null) {
                this.setImage(nativeimage);
            } else {
                this.future = CompletableFuture.runAsync(() -> {
                    HttpURLConnection httpurlconnection = null;
                    HoDTweaks.LOGGER.debug("Downloading http texture from {} to {}", (Object)this.imageUrl, (Object)this.cacheFile);
                    try {
                        httpurlconnection = (HttpURLConnection)new URL(this.imageUrl).openConnection(Minecraft.func_71410_x().func_110437_J());
                        httpurlconnection.setDoInput(true);
                        httpurlconnection.setDoOutput(false);
                        httpurlconnection.setRequestProperty("User-Agent", "Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.11 (KHTML, like Gecko) Chrome/23.0.1271.95 Safari/537.11");
                        httpurlconnection.connect();
                        if (httpurlconnection.getResponseCode() / 100 == 2) {
                            InputStream inputstream;
                            if (this.cacheFile != null) {
                                FileUtils.copyInputStreamToFile((InputStream)httpurlconnection.getInputStream(), (File)this.cacheFile);
                                inputstream = new FileInputStream(this.cacheFile);
                            } else {
                                inputstream = httpurlconnection.getInputStream();
                            }
                            Minecraft.func_71410_x().execute(() -> {
                                NativeImage nativeimage1 = this.loadTexture(inputstream);
                                if (nativeimage1 != null) {
                                    this.setImage(nativeimage1);
                                }
                            });
                            ci.cancel();
                            return;
                        }
                    }
                    catch (Exception var6) {
                        HoDTweaks.LOGGER.error("Couldn't download http texture", (Throwable)var6);
                        this.error = true;
                        ci.cancel();
                        return;
                    }
                    finally {
                        if (httpurlconnection != null) {
                            httpurlconnection.disconnect();
                        }
                    }
                }, Util.func_215072_e());
            }
        }
        ci.cancel();
    }

    @Shadow
    protected abstract void setImage(NativeImage var1);

    @Shadow
    @Nullable
    protected abstract NativeImage loadTexture(InputStream var1);
}

