/*
 * Decompiled with CFR 0.152.
 */
package com.arcaryx.hodtweaks.mixin.pixelmon;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.config.PixelmonConfigProxy;
import com.pixelmonmod.pixelmon.api.events.battles.CatchComboEvent;
import com.pixelmonmod.pixelmon.api.pokemon.species.Species;
import com.pixelmonmod.pixelmon.storage.playerData.CaptureCombo;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraftforge.eventbus.api.Event;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={CaptureCombo.class})
public abstract class MixinCaptureCombo {
    @Shadow
    private Species lastCapture;
    @Shadow
    private int captureCount;

    @Shadow
    public abstract void clearCombo();

    @Inject(at={@At(value="HEAD")}, method={"Lcom/pixelmonmod/pixelmon/storage/playerData/CaptureCombo;onCapture(Lnet/minecraft/entity/player/ServerPlayerEntity;Lcom/pixelmonmod/pixelmon/api/pokemon/species/Species;)V"}, cancellable=true, remap=false)
    private void fixOnCapture(ServerPlayerEntity player, Species species, CallbackInfo ci) {
        if (PixelmonConfigProxy.getBattle().isAllowCatchCombo()) {
            this.captureCount = this.lastCapture != null && this.lastCapture.getDex() == species.getDex() ? ++this.captureCount : 1;
            this.lastCapture = species;
            Pixelmon.EVENT_BUS.post((Event)new CatchComboEvent.ComboIncrement(player, this.lastCapture, this.captureCount));
        } else {
            this.clearCombo();
        }
        ci.cancel();
    }
}

