/*
 * Decompiled with CFR 0.152.
 */
package com.arcaryx.hodtweaks.mixin.pixelmon;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.pokemon.species.Species;
import com.pixelmonmod.pixelmon.api.registries.PixelmonSpecies;
import com.pixelmonmod.pixelmon.api.storage.PlayerPartyStorage;
import com.pixelmonmod.pixelmon.api.storage.TransientData;
import com.pixelmonmod.pixelmon.storage.playerData.CaptureCombo;
import java.lang.reflect.Field;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={PlayerPartyStorage.class})
public abstract class MixinPlayerPartyStorage {
    private static final String NBT_HOD_COMBO_SPECIES_DEX = "HoD_ComboCurrentSpeciesDex";
    private static final String NBT_HOD_COMBO_CURRENT = "HoD_ComboCurrentCombo";
    @Shadow
    public transient TransientData transientData;

    @Inject(at={@At(value="RETURN")}, method={"Lcom/pixelmonmod/pixelmon/api/storage/PlayerPartyStorage;writeToNBT(Lnet/minecraft/nbt/CompoundNBT;)Lnet/minecraft/nbt/CompoundNBT;"}, remap=false, require=1)
    private void extendWriteToNbt(CompoundNBT nbt, CallbackInfoReturnable<CompoundNBT> cir) {
        try {
            if (this.transientData.captureCombo.getCurrentSpecies() != null) {
                Pixelmon.LOGGER.debug("HOD_DEBUG: Writing catch combo data to NBT");
                int catchComboDex = this.transientData.captureCombo.getCurrentSpecies().getDex();
                int catchCombo = this.transientData.captureCombo.getCurrentCombo();
                Pixelmon.LOGGER.debug("HOD_INFO: Writing Species/Combo - " + catchComboDex + "/" + catchCombo);
                ((CompoundNBT)cir.getReturnValue()).func_74768_a(NBT_HOD_COMBO_SPECIES_DEX, catchComboDex);
                ((CompoundNBT)cir.getReturnValue()).func_74768_a(NBT_HOD_COMBO_CURRENT, catchCombo);
            } else {
                Pixelmon.LOGGER.debug("HOD_DEBUG: No catch combo data to write to NBT");
            }
        }
        catch (Exception e) {
            Pixelmon.LOGGER.error("HOD_ERROR: Failed to write catch combo data to NBT", (Throwable)e);
        }
    }

    @Inject(at={@At(value="RETURN")}, method={"Lcom/pixelmonmod/pixelmon/api/storage/PlayerPartyStorage;readFromNBT(Lnet/minecraft/nbt/CompoundNBT;)Lcom/pixelmonmod/pixelmon/api/storage/PlayerPartyStorage;"}, remap=false, require=1)
    private void extendReadFromNbt(CompoundNBT nbt, CallbackInfoReturnable<PlayerPartyStorage> cir) {
        if (nbt.func_74764_b(NBT_HOD_COMBO_SPECIES_DEX) && nbt.func_74764_b(NBT_HOD_COMBO_CURRENT)) {
            Pixelmon.LOGGER.debug("HOD_DEBUG: Reading catch combo data from NBT");
            int catchComboDex = nbt.func_74762_e(NBT_HOD_COMBO_SPECIES_DEX);
            int catchCombo = nbt.func_74762_e(NBT_HOD_COMBO_CURRENT);
            Pixelmon.LOGGER.debug("HOD_DEBUG: Reading Species/Combo - " + catchComboDex + "/" + catchCombo);
            Species catchComboSpecies = PixelmonSpecies.fromNationalDex((Integer)catchComboDex);
            try {
                Field lastCaptureField = CaptureCombo.class.getDeclaredField("lastCapture");
                lastCaptureField.setAccessible(true);
                lastCaptureField.set(((PlayerPartyStorage)cir.getReturnValue()).transientData.captureCombo, catchComboSpecies);
                Field captureCountField = CaptureCombo.class.getDeclaredField("captureCount");
                captureCountField.setAccessible(true);
                captureCountField.set(((PlayerPartyStorage)cir.getReturnValue()).transientData.captureCombo, catchCombo);
                ServerPlayerEntity player = ((PlayerPartyStorage)cir.getReturnValue()).getPlayer();
                String playerName = player == null ? "unknown" : player.func_200200_C_().getString();
                Pixelmon.LOGGER.info("Restored " + playerName + "'s catch combo: " + catchCombo + "x " + catchComboSpecies.getName());
            }
            catch (Exception e) {
                Pixelmon.LOGGER.error("HOD_ERROR: Failed to read catch combo data from NBT", (Throwable)e);
            }
        } else {
            Pixelmon.LOGGER.debug("HOD_DEBUG: No catch combo data found in NBT");
        }
    }
}

