/*
 * Decompiled with CFR 0.152.
 */
package com.arcaryx.hodtweaks.mixin.pixinfo;

import bletch.pixelmoninformation.utils.StringUtils;
import bletch.pixelmoninformation.waila.PixelmonEntityWaila;
import com.pixelmonmod.pixelmon.api.pokemon.Nature;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.pokemon.stats.EVStore;
import com.pixelmonmod.pixelmon.api.pokemon.stats.IVStore;
import com.pixelmonmod.pixelmon.entities.npcs.IndexedNPCEntity;
import com.pixelmonmod.pixelmon.entities.npcs.NPCChatting;
import com.pixelmonmod.pixelmon.entities.npcs.NPCEntity;
import com.pixelmonmod.pixelmon.entities.npcs.NPCFisherman;
import com.pixelmonmod.pixelmon.entities.npcs.NPCNurseJoy;
import com.pixelmonmod.pixelmon.entities.npcs.NPCQuestGiver;
import com.pixelmonmod.pixelmon.entities.npcs.NPCRelearner;
import com.pixelmonmod.pixelmon.entities.npcs.NPCShopkeeper;
import com.pixelmonmod.pixelmon.entities.npcs.NPCTrader;
import com.pixelmonmod.pixelmon.entities.npcs.NPCTrainer;
import com.pixelmonmod.pixelmon.entities.npcs.NPCTutor;
import com.pixelmonmod.pixelmon.entities.pixelmon.PixelmonEntity;
import com.pixelmonmod.pixelmon.enums.EnumNPCTutorType;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={PixelmonEntityWaila.class})
public abstract class MixinPixelmonEntityWaila {
    @Shadow
    private static String NBT_TAG_EVSTORE;
    @Shadow
    private static String NBT_TAG_IVSTORE;
    @Shadow
    private static String NBT_TAG_NATURE;
    @Shadow
    private static String NBT_TAG_NPCNAME;

    @Inject(at={@At(value="HEAD")}, method={"Lbletch/pixelmoninformation/waila/PixelmonEntityWaila;appendServerData(Lnet/minecraft/nbt/CompoundNBT;Lnet/minecraft/entity/player/ServerPlayerEntity;Lnet/minecraft/world/World;Lnet/minecraft/entity/Entity;)V"}, remap=false, cancellable=true)
    public void fixAppendServerData(CompoundNBT data, ServerPlayerEntity player, World world, Entity entity, CallbackInfo ci) {
        PixelmonEntity pixelmon;
        Pokemon pokemon;
        if (entity instanceof PixelmonEntity && (pokemon = (pixelmon = (PixelmonEntity)entity).getPokemon()) != null) {
            CompoundNBT evTag = new CompoundNBT();
            EVStore evStore = pokemon.getEVs();
            evStore.writeToNBT(evTag);
            CompoundNBT ivTag = new CompoundNBT();
            IVStore ivStore = pokemon.getIVs();
            ivStore.writeToNBT(ivTag);
            Nature nature = pokemon.getNature();
            data.func_218657_a(NBT_TAG_EVSTORE, (INBT)evTag);
            data.func_218657_a(NBT_TAG_IVSTORE, (INBT)ivTag);
            data.func_74768_a(NBT_TAG_NATURE, nature.ordinal());
        }
        if (entity instanceof NPCEntity) {
            NPCNurseJoy entityNPC;
            String langCode = player.getLanguage();
            String npcName = "";
            if (entity instanceof NPCFisherman) {
                npcName = "Old Fisherman";
            }
            if (entity instanceof NPCNurseJoy) {
                entityNPC = (NPCNurseJoy)entity;
                String nameKey = entityNPC.getTextureIndex() == 1 ? "gui.nursejoy.name" : "gui.doctorjohn.name";
                npcName = new TranslationTextComponent(nameKey).getString();
            }
            if (entity instanceof NPCQuestGiver) {
                entityNPC = (NPCQuestGiver)entity;
                npcName = entityNPC.getName(langCode);
            }
            if (entity instanceof NPCRelearner) {
                npcName = "Move Relearner";
            }
            if (entity instanceof NPCShopkeeper) {
                entityNPC = (NPCShopkeeper)entity;
                npcName = entityNPC.getShopkeeperName(langCode);
            }
            if (entity instanceof NPCTrader) {
                npcName = "Trader";
            }
            if (entity instanceof NPCTrainer) {
                entityNPC = (NPCTrainer)entity;
                npcName = entityNPC.getName(langCode);
            }
            if (entity instanceof NPCTutor) {
                entityNPC = (NPCTutor)entity;
                String string = npcName = entityNPC.getTutorType() == EnumNPCTutorType.TUTOR ? "Tutor" : "Transfer Tutor";
            }
            if (StringUtils.isNullOrWhitespace((String)npcName).booleanValue() && entity instanceof NPCChatting) {
                entityNPC = (NPCChatting)entity;
                npcName = entityNPC.getName(langCode);
            }
            if (StringUtils.isNullOrWhitespace((String)npcName).booleanValue() && entity instanceof IndexedNPCEntity) {
                entityNPC = (IndexedNPCEntity)entity;
                npcName = entityNPC.getName(langCode);
            }
            if (!StringUtils.isNullOrWhitespace((String)npcName).booleanValue()) {
                data.func_74778_a(NBT_TAG_NPCNAME, npcName);
            }
        }
        ci.cancel();
    }
}

