/*
 * Decompiled with CFR 0.152.
 */
package com.arcaryx.hodtweaks.spawnblock;

import com.pixelmonmod.pixelmon.api.pokemon.species.Species;
import com.pixelmonmod.pixelmon.api.spawning.AbstractSpawner;
import com.pixelmonmod.pixelmon.api.spawning.SpawnAction;
import com.pixelmonmod.pixelmon.entities.pixelmon.PixelmonEntity;
import com.pixelmonmod.pixelmon.init.registry.BlockRegistration;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class CampfireBlock {
    private static int BlockRange = 64;

    public static boolean BlockPixelmonSpawn(SpawnAction action, AbstractSpawner spawner) {
        Entity ent = action.getOrCreateEntity();
        if (ent instanceof PixelmonEntity) {
            PixelmonEntity poke = (PixelmonEntity)ent;
            Species pokeSpecies = poke.getPokemon().getSpecies();
            boolean isLegendary = pokeSpecies.isLegendary() || pokeSpecies.isMythical();
            BlockPos.Mutable spawnLocation = action.spawnLocation.location.pos;
            int chunkRange = (int)Math.ceil((double)BlockRange / 16.0);
            int spawnChunkX = spawnLocation.func_177958_n() >> 4;
            int spawnChunkZ = spawnLocation.func_177952_p() >> 4;
            World world = action.spawnLocation.location.world;
            for (int x = spawnChunkX - chunkRange; x < spawnChunkX + chunkRange; ++x) {
                for (int z = spawnChunkZ - chunkRange; z < spawnChunkZ + chunkRange; ++z) {
                    boolean processChunk = false;
                    if (x == spawnChunkX || z == spawnChunkZ) {
                        processChunk = true;
                    }
                    if (!processChunk) {
                        double cornerDistance;
                        int checkX = x << 4;
                        int checkZ = z << 4;
                        if (x > spawnChunkX) {
                            checkX += 15;
                        }
                        if (z > spawnChunkZ) {
                            checkZ += 15;
                        }
                        boolean bl = processChunk = (cornerDistance = Math.sqrt(Math.pow(checkX - spawnLocation.func_177958_n(), 2.0) + Math.pow(checkZ - spawnLocation.func_177952_p(), 2.0))) <= (double)BlockRange;
                    }
                    if (!processChunk) continue;
                    for (TileEntity tileEnt : world.func_212866_a_(x, z).func_177434_r().values()) {
                        BlockPos campfirePos;
                        double fireDist;
                        if (tileEnt.func_200662_C() != TileEntityType.field_222488_F || !((fireDist = Math.sqrt(Math.pow((campfirePos = tileEnt.func_174877_v()).func_177958_n() - spawnLocation.func_177958_n(), 2.0) + Math.pow(campfirePos.func_177952_p() - spawnLocation.func_177952_p(), 2.0))) <= (double)BlockRange)) continue;
                        if (world.func_180495_p(campfirePos.func_177977_b()).func_177230_c().func_235332_a_((Block)BlockRegistration.CRYSTAL_BLOCK.get()) && !isLegendary) {
                            return true;
                        }
                        if (!world.func_180495_p(campfirePos.func_177977_b()).func_177230_c().func_235332_a_(Blocks.field_150340_R.getBlock())) continue;
                        return true;
                    }
                }
            }
        }
        return false;
    }
}

